/*{
	"GUID":"004AF9BF-A233-4f3a-A14F-2E475C732091",
	"INPUTS":[
		{
			"TYPE":"image",
			"FILE":"FuncMap_Fuzzy.bmp"
		}
	]
}*/

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;
#define vec2 float2
#define vec3 float3
#define vec4 float4

vec4 INPUTSRC(image2d_t src_data,__global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}

vec4 INPUT(image2d_t src_data, vec2 tc)
{
	return read_imagef(src_data, sampler, tc);
}


float WS_DoOverlayPerChannel(float baseVal, float blendVal)
{
    float result;
    
    if(baseVal < 0.5f)
    {
        result = 2.0f * baseVal * blendVal;
    }
    else
        result = 1.0f - 2.0f * (1.0f - baseVal) * (1.0f - blendVal);
    
    return result;
}

__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2, __write_only image2d_t dest_data,
					__global FilterParam* param, int alpha)
{
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[0];;
	float iGlobalTime = param->cur_time / param->total_time;
	
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 iresolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 tc = (vec2)(fragCoord.x + 0.5f, fragCoord.y + 0.5f)/iresolution.xy;
	
    vec4 tuneColor = INPUTSRC(input1, param, tc);
	vec4 col = tuneColor;
    vec4 blendColor = tuneColor;
	
    tuneColor.z = INPUT(input2, (vec2)(tuneColor.z, .16666f)).z;
	tuneColor.y = INPUT(input2, (vec2)(tuneColor.y, .5f)).y;
	tuneColor.x = INPUT(input2, (vec2)(tuneColor.x, .83333f)).x;
    
    tuneColor.z = WS_DoOverlayPerChannel(tuneColor.z, blendColor.z);
    tuneColor.y = WS_DoOverlayPerChannel(tuneColor.y, blendColor.y); 
    tuneColor.x = WS_DoOverlayPerChannel(tuneColor.x, blendColor.x); 
    
    tuneColor.z = INPUT(input2, (vec2)(tuneColor.z, .16666f)).z;
	tuneColor.y = INPUT(input2, (vec2)(tuneColor.y, .5f)).y;
	tuneColor.x = INPUT(input2, (vec2)(tuneColor.x, .83333f)).x;	
   
    float4 outputCol =  col*(1.0f - (float)alpha/100.0f) + (vec4)(tuneColor.x, tuneColor.y, tuneColor.z, 1.0f)*(float)alpha/100.0f; 
	write_imagef(dest_data, gl_FragCoord, (float4)(outputCol.xyz, col.w));
}
